' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Drawing
Imports System.Drawing.Imaging
Imports Toolkit

Partial Class CropImage
  Inherits System.Web.UI.UserControl

  Public Delegate Sub ImageFinalizedEventHandler(ByVal sender As System.Object, _
      ByVal e As FileHandlingEventArgs)
  Public Event ImageFinalized As ImageFinalizedEventHandler

  Private Sub InitializeControl()
    ' pobiez rozmiar obrazka, ebymy mogli obliczy pocztkowy rozmiar prostokta
    ImageSize = Toolkit.Imaging.GetImageSize(Server.MapPath(FileName))

    ' Ustal domylnie na poow szerokoci, poow wysokoci, wyrodkowany wzgledem obrazka
    Left = Convert.ToInt32(ImageSize.Width / 4)
    Top = 0
    Height = ImageSize.Height - 2
    Width = Convert.ToInt32(ImageSize.Width / 2)

    ' Rysuj pocztkowy prostokt
    DrawRectangle()
  End Sub

  Private Sub DrawRectangle()
    ' Rysuj prostokt na obrazie TempFileName i aktualizuj kontrolk Image nowym obrazkiem.
    Dim myRectangle As New Rectangle(New Point(Left, Top), New Size(Width, Height))
    Dim myColor As Color = Color.FromName(lstPenColor.SelectedValue)
    Toolkit.Imaging.DrawRectangle(Server.MapPath(FileName), Server.MapPath(TempFileName), myRectangle, myColor)
    UpdateImageControl(TempFileName)
  End Sub

  Protected Sub btnPreview_Click(ByVal sender As Object, _
                   ByVal e As System.EventArgs) Handles btnPreview.Click
    ' kadruj do obrazka Temp i aktualizuj kontrolk Image.
    Toolkit.Imaging.CropImage(Server.MapPath(FileName), _
          Server.MapPath(TempFileName), New Rectangle(Left, Top, Width, Height))
    UpdateImageControl(TempFileName)
    plcPreviewImage.Visible = False
    cellColor.Visible = False
    rowLocation.Visible = False
    rowSize.Visible = False
    plcFinalizeImage.Visible = True
    btnFinish.Visible = True
  End Sub

  Protected Sub btnUndo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUndo.Click
    ' Ukryj wypeniacz FinalizeImage i przywr wypeniacz PreviewImage.
    ' PreviewImage cigle zawiera orginalny obraz, wic uzytkownikowi wydaje si, e akcja kadrowania zostaa cofnita
    plcFinalizeImage.Visible = False
    plcPreviewImage.Visible = True
    cellColor.Visible = True
    rowLocation.Visible = True
    rowSize.Visible = True
    btnFinish.Visible = False
    DrawRectangle()
  End Sub

  Private Sub UpdateImageControl(ByVal theFileName As String)
    Image1.ImageUrl = String.Format("{0}?TimeStamp={1}", theFileName, System.DateTime.Now.Ticks.ToString())
  End Sub

  Protected Sub lstPenColor_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstPenColor.SelectedIndexChanged
    DrawRectangle()
  End Sub

  Protected Sub btnFullCropArea_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFullCropArea.Click
    Me.Width = ImageSize.Width - 1
    Me.Height = ImageSize.Height - 1
    Me.Left = 0
    Me.Top = 0
    DrawRectangle()
  End Sub


#Region "Waciwoci i metody wsplne dla wszystkich kontrolek uytkownika"

  Public Property FileName() As String
    Get
      If ViewState("FileName") IsNot Nothing Then
        Return ViewState("FileName").ToString()
      Else
        Return String.Empty
      End If
    End Get
    Set(ByVal value As String)
      If ViewState("FileName") Is Nothing Then
        ViewState("FileName") = value
        InitializeControl()
      Else
        ViewState("FileName") = value
      End If
    End Set
  End Property

  Private ReadOnly Property TempFileName() As String
    Get
      If ViewState("TempFileName") Is Nothing Then
        ViewState("TempFileName") = AppConfiguration.TempImagesFolder & "/" & Guid.NewGuid.ToString() & ".jpg"
      End If
      Return ViewState("TempFileName").ToString()
    End Get
  End Property

  Public Property FinishButtonText() As String
    Get
      Return btnFinish.Text
    End Get
    Set(ByVal value As String)
      btnFinish.Text = value
    End Set
  End Property

  Protected Sub btnFinish_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFinish.Click
    FileName = TempFileName
    RaiseEvent ImageFinalized(Me, New FileHandlingEventArgs(FileName))
  End Sub

#End Region

#Region "Prywatne waciwoci"

  Private ReadOnly Property MoveIncrease() As Integer
    Get
      Return Convert.ToInt32(lstMoveSize.SelectedValue)
    End Get
  End Property

  Private ReadOnly Property SizeIncrease() As Integer
    Get
      Return Convert.ToInt32(lstIncreaseSize.SelectedValue)
    End Get
  End Property

  Private Property Left() As Integer
    Get
      If ViewState("Left") IsNot Nothing Then
        Return Convert.ToInt32(ViewState("Left"))
      Else
        Return 0
      End If
    End Get
    Set(ByVal value As Integer)
      ViewState("Left") = value
    End Set
  End Property

  Private Property Top() As Integer
    Get
      If ViewState("Top") IsNot Nothing Then
        Return Convert.ToInt32(ViewState("Top"))
      Else
        Return 0
      End If
    End Get
    Set(ByVal value As Integer)
      ViewState("Top") = value
    End Set
  End Property

  Private Property Height() As Integer
    Get
      If ViewState("Height") IsNot Nothing Then
        Return Convert.ToInt32(ViewState("Height"))
      Else
        Return 0
      End If
    End Get
    Set(ByVal value As Integer)
      ViewState("Height") = value
    End Set
  End Property

  Private Property Width() As Integer
    Get
      If ViewState("Width") IsNot Nothing Then
        Return Convert.ToInt32(ViewState("Width"))
      Else
        Return 0
      End If
    End Get
    Set(ByVal value As Integer)
      ViewState("Width") = value
    End Set
  End Property

  Private Property ImageSize() As Size
    Get
      If ViewState("ImageSize") IsNot Nothing Then
        Return CType(ViewState("ImageSize"), Size)
      Else
        Return New Size(0, 0)
      End If
    End Get
    Set(ByVal value As Size)
      ViewState("ImageSize") = value
    End Set
  End Property
#End Region

#Region "Metody obsugi zdarzenia Click dla przyciskw zmiany rozmiaru"

  Protected Sub btnHeightUp_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnHeightUp.Click
    Height += SizeIncrease
    If Height + Top + 2 >= ImageSize.Height Then
      Height = ImageSize.Height - Top - 2
    End If
    DrawRectangle()
  End Sub

  Protected Sub btnHeightDown_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnHeightDown.Click
    Height -= SizeIncrease
    If Height < 0 Then
      Height = 0
    End If
    DrawRectangle()
  End Sub

  Protected Sub btnWidthUp_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnWidthUp.Click
    Width += SizeIncrease
    If Width + Left + 2 >= ImageSize.Width Then
      Width = ImageSize.Width - Left - 2
    End If
    DrawRectangle()
  End Sub

  Protected Sub btnWidthDown_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnWidthDown.Click
    Width -= SizeIncrease
    If Width < 0 Then
      Width = 0
    End If
    DrawRectangle()
  End Sub

#End Region

#Region "Metody obsugi zdarzenia Click dla przyciskw przemieszczania"

  Protected Sub btnLocationUp_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnLocationUp.Click
    Top -= MoveIncrease
    If Top < 0 Then
      Top = 0
    End If
    DrawRectangle()
  End Sub

  Protected Sub btnLocationLeft_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnLocationLeft.Click
    Left -= MoveIncrease
    If Left < 0 Then
      Left = 0
    End If
    DrawRectangle()
  End Sub

  Protected Sub btnLocationDown_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnLocationDown.Click
    Top += MoveIncrease
    If Top + Height + 2 > ImageSize.Height Then
      Top = ImageSize.Height - Height - 2
    End If
    DrawRectangle()
  End Sub

  Protected Sub btnLocationRight_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnLocationRight.Click
    Left += MoveIncrease
    If Left + Width + 2 > ImageSize.Width Then
      Left = ImageSize.Width - Width - 2
    End If
    DrawRectangle()
  End Sub

#End Region

End Class
